let saldo = 1000000;
let pengeluaranList = [];
let anggaranBulanan = 2000000; // Anda bisa ubah sesuai kebutuhan

// Ambil elemen DOM
const saldoEl = document.getElementById("saldo");
const daftarPengeluaran = document.getElementById("daftar-pengeluaran");
const totalPengeluaranEl = document.getElementById("total-pengeluaran");
const totalRencanaEl = document.getElementById("total-rencana");
const anggaranEl = document.getElementById("anggaran");
const sisaAnggaranEl = document.getElementById("sisa-anggaran");

const modal = document.getElementById("modal");
const addBtn = document.getElementById("add-btn");
const closeBtn = document.querySelector(".close");
const formPengeluaran = document.getElementById("form-pengeluaran");

const namaInput = document.getElementById("nama");
const jumlahInput = document.getElementById("jumlah");
const kuotaInput = document.getElementById("kuota");
const totalOutput = document.getElementById("total-output");

// Buka modal
addBtn.onclick = () => {
    modal.style.display = "block";
};

// Tutup modal
closeBtn.onclick = () => {
    modal.style.display = "none";
};

// Tutup modal jika klik di luar
window.onclick = (event) => {
    if (event.target == modal) {
        modal.style.display = "none";
    }
};

// Form submit
formPengeluaran.onsubmit = function (e) {
    e.preventDefault();

    const nama = namaInput.value.trim();
    const jumlah = parseFloat(jumlahInput.value);
    const kuota = parseInt(kuotaInput.value);

    if (!nama || isNaN(jumlah) || isNaN(kuota)) return;

    const data = {
        id: Date.now(),
        nama,
        jumlah,
        kuota,
        sisa: kuota
    };

    pengeluaranList.push(data);

    // Reset form input supaya kosong
    formPengeluaran.reset();

    // Reset total perhitungan di modal
    totalOutput.textContent = "0";

    // Tutup modal
    modal.style.display = "none";

    // Update tampilan daftar dan saldo
    updateDaftar();
};

// Hitung total di modal
function updateTotal() {
    const jumlah = parseFloat(jumlahInput.value) || 0;
    const kuota = parseInt(kuotaInput.value) || 0;
    const total = jumlah * kuota;
    totalOutput.textContent = total.toLocaleString();
}

jumlahInput.addEventListener("input", updateTotal);
kuotaInput.addEventListener("input", updateTotal);

// Gunakan pengeluaran (saldo boleh minus)
function gunakan(id) {
    const item = pengeluaranList.find(p => p.id === id);
    if (item && item.sisa > 0) {
        saldo -= item.jumlah;
        item.sisa -= 1;
        updateDaftar();
    }
}

// Update tampilan daftar + semua perhitungan
function updateDaftar() {
    daftarPengeluaran.innerHTML = "";

    let totalPengeluaran = 0;
    let totalRencana = 0;

    pengeluaranList.forEach(item => {
        const li = document.createElement("li");

        const sudahDipakai = item.kuota - item.sisa;
        const totalItemAktual = item.jumlah * sudahDipakai;
        const totalItemRencana = item.jumlah * item.kuota;

        totalPengeluaran += totalItemAktual;
        totalRencana += totalItemRencana;

        const disabled = item.sisa <= 0 ? 'disabled' : '';

      li.innerHTML = `
  <span class="item-nama"><strong>${item.nama}</strong></span>
  <div class="info-bar">
    <span class="item-jumlah">Jumlah: Rp ${item.jumlah.toLocaleString()}</span>
    <span class="item-sisa">Sisa: ${item.sisa} / ${item.kuota}</span>
    <span class="item-total">Total: Rp ${totalItemRencana.toLocaleString()}</span>
  </div>
  <button onclick="gunakan(${item.id})" ${disabled}>Gunakan</button>
`;



        daftarPengeluaran.appendChild(li);
    });

    // Update UI
    saldoEl.textContent = saldo.toLocaleString();
    totalPengeluaranEl.textContent = totalPengeluaran.toLocaleString();
    totalRencanaEl.textContent = totalRencana.toLocaleString();
    if (anggaranEl) anggaranEl.textContent = anggaranBulanan.toLocaleString();
    if (sisaAnggaranEl) sisaAnggaranEl.textContent = (anggaranBulanan - totalPengeluaran).toLocaleString();
}
